{{/*
Expand the name of the chart.
*/}}
{{- define "runtime-sensors.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "runtime-sensors.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "runtime-sensors.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Common labels
*/}}
{{- define "runtime-sensors.labels" -}}
helm.sh/chart: {{ include "runtime-sensors.chart" . }}
{{ include "runtime-sensors.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "runtime-sensors.selectorLabels" -}}
app.kubernetes.io/name: {{ include "runtime-sensors.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end }}

{{/*
Create the name of the service account to use
*/}}
{{- define "runtime-sensors.serviceAccountName" -}}
{{- if .Values.serviceAccount.create }}
{{- default (include "runtime-sensors.fullname" .) .Values.serviceAccount.name }}
{{- else }}
{{- default "default" .Values.serviceAccount.name }}
{{- end }}
{{- end }}

{{/*
Create the name of the service account to use for the sensors
*/}}
{{- define "runtime-sensors.SensorsServiceAccountName" -}}
{{- if .Values.sensors.serviceAccount.create }}
{{- default (printf "%s-sensors-service-account" .Release.Name) .Values.sensors.serviceAccount.name }}
{{- else }}
{{- default "default" .Values.sensors.serviceAccount.name }}
{{- end }}
{{- end }}

{{/*
Generate affinity configuration
*/}}
{{- define "runtime-sensors.affinity" -}}
nodeAffinity:
  {{- if .Values.affinity.nodeAffinity.preferredDuringSchedulingIgnoredDuringExecution }}
  preferredDuringSchedulingIgnoredDuringExecution:
    {{- toYaml .Values.affinity.nodeAffinity.preferredDuringSchedulingIgnoredDuringExecution | nindent 6 }}
  {{- end }}
  requiredDuringSchedulingIgnoredDuringExecution:
    nodeSelectorTerms:
      {{- toYaml .Values.affinity.nodeAffinity.requiredDuringSchedulingIgnoredDuringExecution.nodeSelectorTerms | nindent 4 }}
      {{- with .Values.extendedMatchExpressions }}
      {{- toYaml . | nindent 6 }}
      {{- end }}
{{- if .Values.affinity.podAffinity }}
podAffinity:
  {{- toYaml .Values.affinity.podAffinity | nindent 2 }}
{{- end }}
{{- if .Values.affinity.podAntiAffinity }}
podAntiAffinity:
  {{- toYaml .Values.affinity.podAntiAffinity | nindent 2 }}
{{- end }}
{{- end -}}

{{/*
Resolve registrationTokenSecretName value
*/}}
{{- define "runtime-sensors.registrationTokenSecretName" -}}
{{- if .Values.registrationTokenSecretName -}}
{{- .Values.registrationTokenSecretName -}}
{{- else -}}
{{- printf "%s-registration-token" (include "runtime-sensors.fullname" .) -}}
{{- end -}}
{{- end -}}