# Next-Gen CI Demo Helm Chart

A Helm chart for deploying the Next-Gen CI Demo multi-language application (Go, Java, Node.js) packaged in a single Docker container.

## Prerequisites

- Kubernetes 1.19+
- Helm 3.0+

## Installing the Chart

```bash
helm install next-gen-ci-demo ./demo-helm \
  --set image.tag=1.0.0 \
  --set env[0].value=1.0.0
```

## Uninstalling the Chart

```bash
helm uninstall next-gen-ci-demo
```

## Configuration

The following table lists the configurable parameters and their default values.

### Image Configuration

| Parameter | Description | Default |
|-----------|-------------|---------|
| `image.repository` | Image repository | `entplus.jfrog.io/ngcidemo-docker-local/jfrog/next-gen-ci-demo` |
| `image.pullPolicy` | Image pull policy | `IfNotPresent` |
| `image.tag` | Image tag | `""` (uses Chart.AppVersion) |

### Deployment Configuration

| Parameter | Description | Default |
|-----------|-------------|---------|
| `replicaCount` | Number of replicas | `1` |
| `resources.limits.cpu` | CPU limit | `500m` |
| `resources.limits.memory` | Memory limit | `512Mi` |
| `resources.requests.cpu` | CPU request | `100m` |
| `resources.requests.memory` | Memory request | `128Mi` |

### Service Configuration

| Parameter | Description | Default |
|-----------|-------------|---------|
| `service.type` | Service type | `ClusterIP` |
| `service.port` | Service port | `8080` |
| `service.targetPort` | Container port | `8080` |

### Environment Variables

| Parameter | Description | Default |
|-----------|-------------|---------|
| `env[0].name` | VERSION | `1.0.0` |
| `env[1].name` | BUILD_TYPE | `release` |
| `env[2].name` | BUILD_NUMBER | `0` |
| `env[3].name` | PORT | `8080` |

## Example Values Override

```yaml
# custom-values.yaml
replicaCount: 3

image:
  tag: "1.2.3"

resources:
  limits:
    cpu: 1000m
    memory: 1Gi
  requests:
    cpu: 200m
    memory: 256Mi

env:
  - name: VERSION
    value: "1.2.3"
  - name: BUILD_TYPE
    value: "release"
  - name: BUILD_NUMBER
    value: "123"
```

Install with custom values:
```bash
helm install next-gen-ci-demo ./demo-helm -f custom-values.yaml
```

## Application Components

The deployed container includes:
- **Go Application** - Runs on port 8080
- **Java Application** - Maven-built JAR
- **Node.js Application** - TypeScript/Express app

Access individual components:
```bash
# Shell into the pod
kubectl exec -it <pod-name> -- /bin/bash

# Run individual components
/app/entrypoint.sh go
/app/entrypoint.sh java
/app/entrypoint.sh node
```

## Health Checks

The application exposes health endpoints (when Node.js component is running):
- `GET /` - Application info
- `GET /health` - Health status

