{{/*
Expand the name of the chart.
*/}}
{{- define "runtime.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "runtime.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
The runtime-server name
*/}}
{{- define "runtime-server.name" -}}
{{- default .Chart.Name .Values.runtime.AppName .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "runtime-server.fullname" -}}
{{- if .Values.fullnameOverride -}}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- $name := default .Chart.Name .Values.runtime.AppName -}}
{{- if contains $name .Release.Name -}}
{{- .Release.Name | trunc 63 | trimSuffix "-" -}}
{{- else -}}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
{{- end -}}
{{- end -}}
{{- end -}}

{{/*
Create the name of the service account to use
*/}}
{{- define "runtime.serviceAccountName" -}}
{{- if .Values.serviceAccount.create -}}
{{ default (include "runtime.fullname" .) .Values.serviceAccount.name }}
{{- else -}}
{{ default "default" .Values.serviceAccount.name }}
{{- end -}}
{{- end -}}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "runtime.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Scheme (http/https) based on Access TLS enabled/disabled
*/}}
{{- define "runtime.scheme" -}}
{{- if .Values.router.tlsEnabled -}}
{{- printf "%s" "https" -}}
{{- else -}}
{{- printf "%s" "http" -}}
{{- end -}}
{{- end -}}

{{/*
Resolve joinKey value
*/}}
{{- define "runtime.joinKey" -}}
{{- if .Values.global.joinKey -}}
{{- .Values.global.joinKey -}}
{{- else if .Values.runtime.joinKey -}}
{{- .Values.runtime.joinKey -}}
{{- end -}}
{{- end -}}

{{/*
Resolve masterKey value
*/}}
{{- define "runtime.masterKey" -}}
{{- if .Values.global.masterKey -}}
{{- .Values.global.masterKey -}}
{{- else if .Values.runtime.masterKey -}}
{{- .Values.runtime.masterKey -}}
{{- end -}}
{{- end -}}

{{/*
Resolve jfrogUrl value
*/}}
{{- define "runtime.jfrogUrl" -}}
{{- if .Values.global.jfrogUrl -}}
{{- .Values.global.jfrogUrl -}}
{{- else if .Values.runtime.jfrogUrl -}}
{{- .Values.runtime.jfrogUrl -}}
{{- end -}}
{{- end -}}

{{/*
Resolve joinKeySecretName value
*/}}
{{- define "runtime.joinKeySecretName" -}}
{{- if .Values.global.joinKeySecretName -}}
{{- .Values.global.joinKeySecretName -}}
{{- else if .Values.runtime.joinKeySecretName -}}
{{- .Values.runtime.joinKeySecretName -}}
{{- else -}}
{{- printf "%s-unified-secret" (include "runtime.fullname" .) -}}
{{- end -}}
{{- end -}}

{{/*
Resolve masterKeySecretName value
*/}}
{{- define "runtime.masterKeySecretName" -}}
{{- if .Values.global.masterKeySecretName -}}
{{- .Values.global.masterKeySecretName -}}
{{- else if .Values.runtime.masterKeySecretName -}}
{{- .Values.runtime.masterKeySecretName -}}
{{- else -}}
{{- printf "%s-unified-secret" (include "runtime.fullname" .) -}}
{{- end -}}
{{- end -}}

{{/*
Resolve imagePullSecrets value
*/}}
{{- define "runtime.imagePullSecrets" -}}
{{- if .Values.global.imagePullSecrets }}
imagePullSecrets:
{{- range .Values.global.imagePullSecrets }}
  - name: {{ . }}
{{- end }}
{{- else if .Values.imagePullSecrets }}
imagePullSecrets:
{{- range .Values.imagePullSecrets }}
  - name: {{ . }}
{{- end }}
{{- end -}}
{{- end -}}

{{/*
Resolve customInitContainersBegin value
*/}}
{{- define "runtime.customInitContainersBegin" -}}
{{- if .Values.global.customInitContainersBegin -}}
{{- .Values.global.customInitContainersBegin -}}
{{- end -}}
{{- if .Values.common.customInitContainersBegin -}}
{{- .Values.common.customInitContainersBegin -}}
{{- end -}}
{{- end -}}

{{/*
Resolve customInitContainers value
*/}}
{{- define "runtime.customInitContainers" -}}
{{- if .Values.global.customInitContainers -}}
{{- .Values.global.customInitContainers -}}
{{- end -}}
{{- if .Values.common.customInitContainers -}}
{{- .Values.common.customInitContainers -}}
{{- end -}}
{{- end -}}

{{/*
Resolve customVolumes value
*/}}
{{- define "runtime.customVolumes" -}}
{{- if .Values.global.customVolumes -}}
{{- .Values.global.customVolumes -}}
{{- end -}}
{{- if .Values.common.customVolumes -}}
{{- .Values.common.customVolumes -}}
{{- end -}}
{{- end -}}


{{/*
Resolve customVolumeMounts value
*/}}
{{- define "runtime.customVolumeMounts" -}}
{{- if .Values.global.customVolumeMounts -}}
{{- .Values.global.customVolumeMounts -}}
{{- end -}}
{{- if .Values.common.customVolumeMounts -}}
{{- .Values.common.customVolumeMounts -}}
{{- end -}}
{{- end -}}

{{/*
Resolve customSidecarContainers value
*/}}
{{- define "runtime.customSidecarContainers" -}}
{{- if .Values.global.customSidecarContainers -}}
{{- .Values.global.customSidecarContainers -}}
{{- end -}}
{{- if .Values.common.customSidecarContainers -}}
{{- .Values.common.customSidecarContainers -}}
{{- end -}}
{{- end -}}

{{/*
Resolve customCertificates enabled value
Returns "true" if enabled, empty string if disabled
*/}}
{{- define "runtime.customCertificatesEnabled" -}}
{{- if or .Values.global.customCertificates.enabled .Values.runtime.customCertificates.enabled -}}
true
{{- end -}}
{{- end -}}

{{/*
Resolve customCertificates secret name
*/}}
{{- define "runtime.customCertificatesSecretName" -}}
{{- if .Values.global.customCertificates.certificateSecretName -}}
{{- .Values.global.customCertificates.certificateSecretName -}}
{{- else if .Values.runtime.customCertificates.certificateSecretName -}}
{{- .Values.runtime.customCertificates.certificateSecretName -}}
{{- end -}}
{{- end -}}

{{/*
Custom certificate copy command
Copies certificates to trusted directory (like Xray) and creates a bundle file for SSL_CERT_FILE.
*/}}
{{- define "runtime.copyCustomCerts" -}}
{{- if or .Values.runtime.customCertificates.enabled .Values.global.customCertificates.enabled -}}
echo "Copy custom certificates to {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted";
mkdir -p {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted;
if [ -f /etc/pki/tls/certs/ca-bundle.crt ]; then
  echo "Copying system CA bundle from /etc/pki/tls/certs/ca-bundle.crt";
  cat /etc/pki/tls/certs/ca-bundle.crt > {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/ca-bundle.crt;
elif [ -f /etc/ssl/certs/ca-certificates.crt ]; then
  echo "Copying system CA bundle from /etc/ssl/certs/ca-certificates.crt";
  cat /etc/ssl/certs/ca-certificates.crt > {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/ca-bundle.crt;
else
  echo "No system CA bundle found, creating empty bundle";
  touch {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/ca-bundle.crt;
fi;
for file in $(ls -1 /tmp/certs/* 2>/dev/null | grep -v .key | grep -v ":" | grep -v grep); do if [ -f "${file}" ]; then cp -v ${file} {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted; cat "${file}" >> {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/ca-bundle.crt; fi done;
if [ -f {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/tls.crt ]; then mv -v {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/tls.crt {{ .Values.runtime.persistence.mountPath }}/etc/security/keys/trusted/ca.crt; fi;
{{- end -}}
{{- end -}}

{{/*
Resolve runtime requiredServiceTypes value
*/}}
{{- define "runtime.router.requiredServiceTypes" -}}
{{- $requiredTypes := "jfrun" -}}
{{- $requiredTypes -}}
{{- end -}}

{{/*
Resolve unifiedCustomSecretVolumeName value
*/}}
{{- define "runtime.unifiedCustomSecretVolumeName" -}}
{{- printf "%s-%s" (include "runtime.name" .) ("unified-secret-volume") | trunc 63 -}}
{{- end -}}

{{/*
Check the Duplication of volume names for secrets. If unifiedSecretInstallation is enabled then the method is checking for volume names,
if the volume exists in customVolume then an extra volume with the same name will not be getting added in unifiedSecretInstallation case.
*/}}
{{- define "runtime.checkDuplicateUnifiedCustomVolume" -}}
{{- if or .Values.global.customVolumes .Values.common.customVolumes -}}
{{- $val := (tpl (include "runtime.customVolumes" .) .) | toJson -}}
{{- contains (include "runtime.unifiedCustomSecretVolumeName" .) $val | toString -}}
{{- else -}}
{{- printf "%s" "false" -}}
{{- end -}}
{{- end -}}

{{/*
Common labels
*/}}
{{- define "runtime.labels" -}}
helm.sh/chart: {{ include "runtime.chart" . }}
{{ include "runtime.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "runtime.selectorLabels" -}}
app.kubernetes.io/name: {{ include "runtime.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end }}

